/**
 *
 * \file        Hid.hpp
 *
 * \brief       Declaration for Functions for transmitting HID data over IP
 *
 * \author      AKN
 *
 * \date        10/26/2008
 *
 */
#ifndef _HID_H_
#define _HID_H_

#include "dm_Hid.h"

#ifdef __cplusplus
extern "C" {
#endif

#define HID_UDPP_MSG			0x50
#define HID_DIRECT_TOUCH_MSG	0x51
//HID connection type defines. The values should match the ones coming from control system for the
//connection type.
#define HID_CONNECTION_NONE         0xFF
#define HID_CONNECTION_TCP          0x00
#define HID_CONNECTION_UDP          0x01
#define USB_HID_PORT              42872


// Defines for connection control routine
#define HID_OPEN_TCP_CONN           0x0001
#define HID_OPEN_UDP_CONN           0x0002
#define HID_NO_CONN                 0x0004
#define HID_ADDR_CHANGED            0x0008
#define HID_PORT_CHANGED            0x0010
#define HID_RESET_CONN              0x0020

#define HID_MOUSE_DATA              0x01
#define HID_KEYBOARD_DATA           0x02


#define GW_TCP_NOTCONNECTED   0
#define GW_TCP_CONNECTED      1
#define GW_TCP_TERMINATED     2
#define NU_NOT_CONNECTED      1

//#define SEND_HID_UDP	0
//#define SEND_HID_TCP	1
    //Bitmap
#define SEND_HID_NONE	0
#define SEND_HID_TCP	1
#define SEND_HID_UDP	2

#define HID_TASK_STACK_SIZE 240
//this need to be the same priority as NetTcpReadTask to allow 
//for resource initialization before NetTcpReadTask is scheduled
//a higher priority task will pre-empt a low priority task that created it  
#define HID_TASK_PRIORITY    2  //aws- need to make this the same preprocessor as basicwebWEBSERVER_PRIORITY ( tskIDLE_PRIORITY + 2 )

    INT32 HIDSendMessage(char* pBuf, int size);
	void RestoreDefaultHIDParameters(void);

#ifdef __cplusplus
}
#endif

#endif
